// answerbutton.as


Answerbox = function () {
	this.propActive = true;
	this.propAlive = true;
	this.propAnswerText = '';
	this.propExplanationText = '';
	this.propClicked = false;
	this.propCorrect = false;
	this.propTextPadding = 0;
	this.propBgColors = [0xFFFFFF,0xFFFFFF,0xFFFFFF,0xFFFFFF,0xFFFFFF,0xFFFFFF];
	this.propOlColors = [0x000000,0x000000,0x000000,0x000000,0x000000,0x000000];
	this.propTextColors = [0x000000,0x000000,0x000000,0x000000,0x000000,0x000000];
	this.propTextFormat = new TextFormat ();

	this.propBgCol = new Color (this.i_bg);
	this.propOlCol = new Color (this.i_ol);
	this.i_bg.gotoAndStop (1);
	this.i_ol.gotoAndStop (1);

	this.createTextField ('i_text', 10, 0, 0, this._width, this._height);
	this.i_text.multiline = true;
	this.i_text.wordWrap = true;
	this.i_text.embedFonts = true;
	this.i_text.selectable = false;
	this.i_text.html = true;
	this.i_text.setNewTextFormat (this.propTextFormat);
	this.i_text.htmlText = 'Answer text';
	this.i_text.setTextFormat (this.propTextFormat);
	
	this.propOnRelease = function () {}
}

Answerbox.prototype = new MovieClip ();

// --------------------- METHODS --------------------

Answerbox.prototype.getAnswerText = function () {
	return this.propAnswerText;
	ASSetPropFlags (Answerbox.prototype, ['getAnswerText'], 1);
}

Answerbox.prototype.setAnswerText = function (p) {
	this.propAnswerText = p;
	this.i_text.htmlText = this.propAnswerText;
	this.i_text.setTextFormat (this.propTextFormat);
	this.resetTextBox ();
	this.adjustBoxSize ();
	ASSetPropFlags (Answerbox.prototype, ['setAnswerText'], 1);
}

Answerbox.prototype.getExplanationText = function () {
	return this.propExplanationText;
	ASSetPropFlags (Answerbox.prototype, ['getExplanationText'], 1);
}

Answerbox.prototype.setExplanationText = function (p) {
	this.propExplanationText = p;
	ASSetPropFlags (Answerbox.prototype, ['setExplanationText'], 1);
}

Answerbox.prototype.getClicked = function () {
	return this.propClicked;
	ASSetPropFlags (Answerbox.prototype, ['getClicked'], 1);
}

Answerbox.prototype.setClicked = function (p) {
	ASSetPropFlags (Answerbox.prototype, ['setClicked'], 1);
}

Answerbox.prototype.getCorrect = function () {
	return this.propCorrect;
	ASSetPropFlags (Answerbox.prototype, ['getCorrect'], 1);
}

Answerbox.prototype.setCorrect = function (p) {
	this.propCorrect = p;
	ASSetPropFlags (Answerbox.prototype, ['setCorrect'], 1);
}

Answerbox.prototype.getTextPadding = function () {
	return this.propTextPadding;
	ASSetPropFlags (Answerbox.prototype, ['getTextPadding'], 1);
}

Answerbox.prototype.setTextPadding = function (p) {
	this.propTextPadding = p;
	this.resetTextBox ();
	this.adjustBoxSize ();
	ASSetPropFlags (Answerbox.prototype, ['setTextPadding'], 1);
}

Answerbox.prototype.getBgColors = function () {
	return this.propBgColors;
	ASSetPropFlags (Answerbox.prototype, ['getBgColors'], 1);
}

Answerbox.prototype.setBgColors = function (p) {
	this.propBgColors = p;
	this.propBgCol.setRGB (this.propBgColors[0]);
	ASSetPropFlags (Answerbox.prototype, ['setBgColors'], 1);
}

Answerbox.prototype.getOlColors = function () {
	return this.propOlColors;
	ASSetPropFlags (Answerbox.prototype, ['getOlColors'], 1);
}

Answerbox.prototype.setOlColors = function (p) {
	this.propOlColors = p;
	this.propOlCol.setRGB (this.propOlColors[0]);
	ASSetPropFlags (Answerbox.prototype, ['setOlColors'], 1);
}

Answerbox.prototype.getTextFormat = function () {
	return this.propTextFormat;
	ASSetPropFlags (Answerbox.prototype, ['getTextFormat'], 1);
}

Answerbox.prototype.setTextFormat = function (p) {
	this.propTextFormat = p;
	this.i_text.setTextFormat (this.propTextFormat);
	this.resetTextBox ();
	this.adjustBoxSize ();
	ASSetPropFlags (Answerbox.prototype, ['setTextFormat'], 1);
}

Answerbox.prototype.getTextColors = function () {
	return this.propTextColors;
	ASSetPropFlags (Answerbox.prototype, ['getTextColors'], 1);
}

Answerbox.prototype.setTextColors = function (p) {
	this.propTextColors = p;
	this.propTextFormat.color = this.propTextColors[0];
	this.i_text.setTextFormat (this.propTextFormat);
	ASSetPropFlags (Answerbox.prototype, ['setTextColors'], 1);
}

Answerbox.prototype.resetTextBox = function () {
	this.i_text._x = this.propTextPadding;
	this.i_text._y = this.propTextPadding * .6;
	this.i_text._width = this._width - (this.propTextPadding * 2);
	this.i_text._height = this.i_text.textHeight + 6;

	ASSetPropFlags (Answerbox.prototype, ['resetTextBox'], 1);
}

Answerbox.prototype.adjustBoxSize = function () {
	var l = Math.floor (this.i_text.textHeight / this.propTextFormat.size);
	l = (l == 0) ? 1 : l;
	this.i_bg.gotoAndStop (l);
	this.i_ol.gotoAndStop (l);

	ASSetPropFlags (Answerbox.prototype, ['adjustBoxSize'], 1);
}

Answerbox.prototype.onRollOver = function () {
	if (this.propActive && this.propAlive) {
		this.propBgCol.setRGB (this.propBgColors[1]);
		this.propOlCol.setRGB (this.propOlColors[1]);
		debug_trace (this.correct);
	}
	ASSetPropFlags (Answerbox.prototype, ['onRollOver'], 1);
}

Answerbox.prototype.onRollOut = function () {
	if (this.propActive && this.propAlive) {
		this.propBgCol.setRGB (this.propBgColors[0]);
		this.propOlCol.setRGB (this.propOlColors[0]);
	}
	ASSetPropFlags (Answerbox.prototype, ['onRollOut'], 1);
}

Answerbox.prototype.onReleaseOutside = function () {
	if (this.propActive && this.propAlive) {
		this.onRollOut ();
	}
	ASSetPropFlags (Answerbox.prototype, ['onReleaseOutside'], 1);
}

Answerbox.prototype.onRelease = function () {
	if (this.propActive && this.propAlive) {
		this.propClicked = true;
		this.propOnRelease (this);
//		this.kill ();
	}
	ASSetPropFlags (Answerbox.prototype, ['onRelease'], 1);
}

Answerbox.prototype.kill = function () {
	this.propAlive = false;
	this.useHandCursor = false;
	if (this.propCorrect & this.propClicked) {
		var n = 3;
	} else if (this.propCorrect) {
		var n = 5;
	} else if (this.propClicked) {
		var n = 4;
	} else {
		var n = 2;
	}
	this.propBgCol.setRGB (this.propBgColors[n]);
	this.propOlCol.setRGB (this.propOlColors[n]);
	this.propTextFormat.color = this.propTextColors[n];
	this.i_text.setTextFormat (this.propTextFormat);

	ASSetPropFlags (Answerbox.prototype, ['kill'], 1);
}

//  ---------------- PROPERTIES -----------------

Answerbox.prototype.addProperty ('answerText', Answerbox.prototype.getAnswerText, Answerbox.prototype.setAnswerText);
Answerbox.prototype.addProperty ('explanationText', Answerbox.prototype.getExplanationText, Answerbox.prototype.setExplanationText);
Answerbox.prototype.addProperty ('clicked', Answerbox.prototype.getClicked, Answerbox.prototype.setClicked);
Answerbox.prototype.addProperty ('correct', Answerbox.prototype.getCorrect, Answerbox.prototype.setCorrect);
Answerbox.prototype.addProperty ('textPadding', Answerbox.prototype.getTextPadding, Answerbox.prototype.setTextPadding);
Answerbox.prototype.addProperty ('bgColors', Answerbox.prototype.getBgColors, Answerbox.prototype.setBgColors);
Answerbox.prototype.addProperty ('olColors', Answerbox.prototype.getOlColors, Answerbox.prototype.setOlColors);
Answerbox.prototype.addProperty ('textFormat', Answerbox.prototype.getTextFormat, Answerbox.prototype.setTextFormat);
Answerbox.prototype.addProperty ('textColors', Answerbox.prototype.getTextColors, Answerbox.prototype.setTextColors);




Object.registerClass ('m_ansbox', Answerbox);
