// button.as

Buttonbox = function () {
	this.propActive = true;
	this.propAlive = true;
	this.propBgCol = new Color (this.i_bg);
	this.propOlCol = new Color (this.i_ol);
	this.propTextCol = new Color (this.i_text);
	this.propBgColors = [];
	this.propOlColors = [];
	this.propTextColors = [];
	this.setBgColors ([0xFFFFFF,0xFFFFFF,0xFFFFFF]);
	this.setOlColors ([0x000000,0x000000,0x000000]);
	this.setTextColors ([0x000000,0x000000,0x000000]);
	this.propTextFormat = this.i_text.getTextFormat ();
	this.i_text.text = this.i_text.text;

	this.propOnRelease = function () {}
}

Buttonbox.prototype = new MovieClip ();

// --------------------- METHODS --------------------

Buttonbox.prototype.getAlive = function () {
	return this.propAlive;
	ASSetPropFlags (Buttonbox.prototype, ['getAlive'], 1);
}

Buttonbox.prototype.setAlive = function (p) {
	ASSetPropFlags (Buttonbox.prototype, ['setAlive'], 1);
}

Buttonbox.prototype.getBgColors = function () {
	return this.propBgColors;
	ASSetPropFlags (Buttonbox.prototype, ['getBgColors'], 1);
}

Buttonbox.prototype.setBgColors = function (p) {
	this.propBgColors = p;
	this.propBgCol.setRGB (this.propBgColors[0]);
	ASSetPropFlags (Buttonbox.prototype, ['setBgColors'], 1);
}

Buttonbox.prototype.getOlColors = function () {
	return this.propOlColors;
	ASSetPropFlags (Buttonbox.prototype, ['getOlColors'], 1);
}

Buttonbox.prototype.setOlColors = function (p) {
	this.propOlColors = p;
	this.propOlCol.setRGB (this.propOlColors[0]);
	ASSetPropFlags (Buttonbox.prototype, ['setOlColors'], 1);
}

Buttonbox.prototype.getTextColors = function () {
	return this.propTextColors;
	ASSetPropFlags (Buttonbox.prototype, ['getTextColors'], 1);
}

Buttonbox.prototype.setTextColors = function (p) {
	this.propTextColors = p;
	this.propTextFormat.color = this.propTextColors[0];
	this.i_text.setTextFormat (this.propTextFormat);
	ASSetPropFlags (Buttonbox.prototype, ['setTextColors'], 1);
}

Buttonbox.prototype.onRollOver = function () {
	if (this.propActive && this.propAlive) {
		this.propBgCol.setRGB (this.propBgColors[1]);
		this.propOlCol.setRGB (this.propOlColors[1]);
		this.propTextFormat.color = this.propTextColors[1];
		this.i_text.setTextFormat (this.propTextFormat);
	}
	ASSetPropFlags (Buttonbox.prototype, ['onRollOver'], 1);
}

Buttonbox.prototype.onRollOut = function () {
	if (this.propActive && this.propAlive) {
		this.propBgCol.setRGB (this.propBgColors[0]);
		this.propOlCol.setRGB (this.propOlColors[0]);
		this.propTextFormat.color = this.propTextColors[0];
		this.i_text.setTextFormat (this.propTextFormat);
	}
	ASSetPropFlags (Buttonbox.prototype, ['onRollOut'], 1);
}

Buttonbox.prototype.onReleaseOutside = function () {
	if (this.propActive && this.propAlive) {
		this.onRollOut ();
	}
	ASSetPropFlags (Buttonbox.prototype, ['onReleaseOutside'], 1);
}

Buttonbox.prototype.onRelease = function () {
	if (this.propActive && this.propAlive) {
		this.propOnRelease (this);
	}
	ASSetPropFlags (Buttonbox.prototype, ['onRelease'], 1);
}

Buttonbox.prototype.deactivate = function () {
	if (this.propAlive) {
		this.propActive = false;
		this.useHandCursor = false;
	}
	ASSetPropFlags (Buttonbox.prototype, ['deactivate'], 1);
}

Buttonbox.prototype.activate = function () {
	if (this.propAlive) {
		this.propActive = true;
		this.useHandCursor = true;
	}
	ASSetPropFlags (Buttonbox.prototype, ['activate'], 1);
}

Buttonbox.prototype.kill = function () {
	this.gotoAndStop (4);
	this.propBgCol.setRGB (this.propBgColors[2]);
	this.propOlCol.setRGB (this.propOlColors[2]);
	this.useHandCursor = false;
	this.propAlive = false;
	ASSetPropFlags (Buttonbox.prototype, ['kill'], 1);
}


//  ---------------- PROPERTIES -----------------

Buttonbox.prototype.addProperty ('alive', Buttonbox.prototype.getAlive, Buttonbox.prototype.setAlive);
Buttonbox.prototype.addProperty ('bgColors', Buttonbox.prototype.getBgColors, Buttonbox.prototype.setBgColors);
Buttonbox.prototype.addProperty ('olColors', Buttonbox.prototype.getOlColors, Buttonbox.prototype.setOlColors);
Buttonbox.prototype.addProperty ('textColors', Buttonbox.prototype.getTextColors, Buttonbox.prototype.setTextColors);


Object.registerClass ('m_buttonbox', Buttonbox);
