MovieClip.prototype.moveToA = function (v) { // v = [x,y]
	this._x = v[0];
	this._y = v[1];
	ASSetPropFlags (MovieClip.prototype, ['moveToA'], 1);
}

MovieClip.prototype.moveBy = function (v) { // v = [x,y]
	this._x += v[0];
	this._y += v[1];
	ASSetPropFlags (MovieClip.prototype, ['moveBy'], 1);
}

MovieClip.prototype.tweenTo = function (argArray) { // tweenArray,steps
//	trace (this._name + ' tweenTo' + argArray);
	this.propList = argArray[0];
	this.tweenSteps = argArray[1];
	this.tweenVector = [];
	for (var i=0; i<this.propList.length; i++) {
		var p = this.propList[i][0];
		var s = this[p];
		var e = this.propList[i][1];
		var v = e - s;
		this.tweenVector.push ([p,s,e,v]);
	}
	delete this.propList;
	this.tweenStepCount = 0;
	this.onEnterFrame = function () { this.tweenStep (); }
	ASSetPropFlags (MovieClip.prototype, ['tweenTo'], 1);
}

MovieClip.prototype.getGlobalCoords = function () { // returns [x,y]
	this.point = new Object ();
	this.point.x = this._x;
	this.point.y = this._y;
	localToGlobal (this.point);
	this.rtnArray = [this.point.x, this.point.y];
	return this.rtnArray;
	delete this.rtnArray;
	ASSetPropFlags (MovieClip.prototype, ['getGlobalCoords'], 1);
}

MovieClip.prototype.tweenStep = function () {
//	trace (this._name + ' tweenstep' + this.tweenStepCount);
	if (this.tweenStepCount <= this.tweenSteps) {
		for (var i=0; i<this.tweenVector.length; i++) {
			this[this.tweenVector[i][0]] = Math.easeOutCubic (this.tweenStepCount, this.tweenVector[i][1], this.tweenVector[i][3], this.tweenSteps);
		}
		this.tweenStepCount ++;
	} else {
		for (var i=0; i<this.tweenVector.length; i++) {
			this[this.tweenVector[i][0]] = this.tweenVector[i][2];
		}
		_level0.i_eventQueue.endWait ();
		this.onEnterFrame = null;
		delete this.tweenVector;
		delete this.tweenSteps;
		delete this.tweenStepCount;
	}
	ASSetPropFlags (MovieClip.prototype, ['tweenStep'], 1);
}

MovieClip.prototype.addTint = function (r, g, b, a) {
	var clr = new Color (this);
	clr.setTint (r, g, b, a);
	delete (clr);
	ASSetPropFlags (MovieClip.prototype, ['addTint'], 1);
}

MovieClip.prototype.removeTint = function () {
	var clr = new Color (this);
	clr.reset ();
	delete (clr);
	ASSetPropFlags (MovieClip.prototype, ['removeTint'], 1);
}

MovieClip.prototype.hide = function () {
	debug_trace ('hide: ' + this._name);
	this._visible = false;
	ASSetPropFlags (MovieClip.prototype, ['hide'], 1);
}

MovieClip.prototype.show = function () {
	this._visible = true;
	ASSetPropFlags (MovieClip.prototype, ['show'], 1);
}

