TextField.prototype.moveToA = function (v) { // v = [x,y]
	this._x = v[0];
	this._y = v[1];
	ASSetPropFlags (TextField.prototype, ['moveToA'], 1);
}

TextField.prototype.moveBy = function (v) { // v = [x,y]
	this._x += v[0];
	this._y += v[1];
	ASSetPropFlags (TextField.prototype, ['moveBy'], 1);
}

TextField.prototype.tweenTo = function (argArray) { // tweenArray,steps
	this.propList = argArray[0];
	this.tweenSteps = argArray[1];
	this.tweenVector = [];
	for (var i=0; i<this.propList.length; i++) {
		var p = this.propList[i][0];
		var s = this[p];
		var e = this.propList[i][1];
		var v = e - s;
		this.tweenVector.push ([p,s,e,v]);
	}
	delete this.propList;
	this.tweenStepCount = 0;
	this.onEnterFrame = function () { this.tweenStep (); }
	ASSetPropFlags (TextField.prototype, ['tweenTo'], 1);
}

TextField.prototype.tweenStep = function () {
	if (this.tweenStepCount <= this.tweenSteps) {
		for (var i=0; i<this.tweenVector.length; i++) {
			this[this.tweenVector[i][0]] = Math.easeOutCubic (this.tweenStepCount, this.tweenVector[i][1], this.tweenVector[i][3], this.tweenSteps);
		}
		this.tweenStepCount ++;
	} else {
		for (var i=0; i<this.tweenVector.length; i++) {
			this[this.tweenVector[i][0]] = this.tweenVector[i][2];
		}
		_level0.i_eventQueue.endWait ();
		this.onEnterFrame = null;
	}
	ASSetPropFlags (TextField.prototype, ['tweenStep'], 1);
}

TextField.prototype.hide = function () {
	this._visible = false;
	ASSetPropFlags (TextField.prototype, ['hide'], 1);
}

TextField.prototype.show = function () {
	this._visible = true;
	ASSetPropFlags (TextField.prototype, ['show'], 1);
}

