// laptop.as

/* ---------------- INCLUDE LIBRARIES ------------------- */

#include "MovieClip_extensions.as"
#include "Array_extensions.as"
#include "TextField_extensions.as"
#include "color_extensions.as"
#include "easing.as"
#include "Answerbox.as"
#include "Buttonbox.as"
#include "event_queue.as"
#include "typewriter.as"

/* ---------------- DECLARATION ------------------- */

// _root variables

var introT1str = 'Agent Smith, Im your handler for your new mission: pick up a laptop computer from our double agent and bring it back to HQ. Because you bungled your last mission, were monitoring you closely. Along the way, Im going to ask you a few questions about keeping the laptop and its contents secure.';
var introT2str = 'Be careful with this laptop  one false move and it could end up in the wrong hands. As long as you answer questions correctly, youll probably accomplish your mission. But if you miss a few questions, well be very disappointed... in fact, we may have to revoke your security clearance. Good luck.';

var tabData = [];
tabData.push ([[22,393],'left','22:45','the exchange']);
tabData.push ([[619,393],'right','23:20','the hotel']);
tabData.push ([[619,393],'right','05:50','the security line']);
tabData.push ([[22,393],'left','06:05','the airport']);
tabData.push ([[22,393],'left','09:40','the parking lot']);
tabData.push ([[619,393],'right','09:45','the coffee shop']);

var debug = true;

_global.jdgButtonHold = false;
var depthCount = 50;
var attachedMcs = [];
var hiddenBoxMcs = [];
var buttonBlinkRate = 500; //ms
var swfRoot = _root;
var firstPlay = true;
var turnInProgress = false;
var playerMaxMisses = 3;

var questionCount = 6;

var playerMisses, currentQuestion;

var scenes = ['scene1','scene2','scene3','scene4','scene5','scene6'];
var currentScene;
var sceneXformMatrix;

var quboxPos = [64,42];

var boxStart = [45, 50];
var boxSpacing = [140, 113];

var continueButtonPos = [178, 331];

var questionTextPadding = 22;
var answerTextPadding = 6;

var answerBoxYSpacing = 8;
var answerBoxIndent = 24;

var soundPlaying = true;
var fadedSoundVolume = 10;
var soundFadeDuration = 31;

//                     [normal,   rollover, dead,     correct/selected, incorrect/selected, correct/unselected]
var ansboxBgColors =   [0xffffff, 0xffffff, 0xffffff, 0xcadb2a,         0xbf272d,           0xffffff];
var ansboxOlColors =   [0x000000, 0xffbf00, 0x9d9fa1, 0x000000,         0x000000,           0x6c9c31];
var ansboxTextColors = [0x000000, 0x000000, 0x9d9fa1, 0xFFFFFF,         0xFFFFFF,           0x6c9c31];

// [normal, rollover, dead]
var barbtnBgColors = [0x8ED8F8,0x8ED8F8,0x3789CC];
var barbtnOlColors = [0xFFFFFF,0xFFC20E,0xFFFFFF];
var barbtnTextColors = [0xFFFFFF,0xFFFFFF,0xFFFFFF];

// [normal, rollover, dead]
var contbtnBgColors = [0xFFFFFF,0xFFFFFF,0xFFFFFF];
var contbtnOlColors = [0x0054a5,0xffbf00,0xb9cce9];
var contbtnTextColors = [0x0054a5,0x005CAC,0xb9cce9];

var ansboxTf = new TextFormat ();
ansboxTf.align = 'left';
ansboxTf.font = 'f_TheSansBold';
ansboxTf.size = 12;
ansboxTf.color = 0x000000;

var ansboxBoolTf = new TextFormat ();
ansboxBoolTf.align = 'center';
ansboxBoolTf.font = 'f_TheSansBold';
ansboxBoolTf.size = 12;
ansboxBoolTf.color = 0x000000;

var questionTf = new TextFormat ();
questionTf.align = 'left';
questionTf.font = 'f_TheSansBold';
questionTf.size = 14;
questionTf.color = 0xbf272d;

var explanationTf= new TextFormat ();
explanationTf.align = 'left';
explanationTf.font = 'f_TheSansBold';
explanationTf.color = 0x000000;
explanationTf.size = 13;

var introTypewTf = new TextFormat ();
introTypewTf.font = 'f_bankGothic';
introTypewTf.size = 25;
introTypewTf.color = 0xffffff;
introTypewTf.align = 'left';

var tabTimeTypewTf = new TextFormat ();
tabTimeTypewTf.font = 'f_bankGothic';
tabTimeTypewTf.size = 20;
tabTimeTypewTf.color = 0xbf272d;
tabTimeTypewTf.align = 'left';

var tabLocTypewTf = new TextFormat ();
tabLocTypewTf.font = 'f_bankGothic';
tabLocTypewTf.size = 20;
tabLocTypewTf.color = 0x000000;
tabLocTypewTf.align = 'left';

/* ---------------- SOUNDS ------------------- */

var queuedSound;
var soundLoadQueue = [];
var soundList = [];
loadQueuedSound = function () {
	debug_trace ('loaded queuedSound: ' + _root.queuedSound.sourcename);
	if (_root.queuedSound.ambient) {
		_root.queuedSound.start (0,1000);
		_root.queuedSound.playing = true;
	}
	if (_root.soundLoadQueue.length > 0) {
		debug_trace ('soundLoadQueue.length: ' + _root.soundLoadQueue.length);
		var qs = _root.soundLoadQueue.pop ();
		_root.queuedSound = qs;
		if (qs.external) {
			debug_trace ('loading queuedSound: ' + qs.sourcename);
			qs.onLoad = _root.loadQueuedSound;
			qs.loadSound (qs.sourcename);
		} else {
			debug_trace ('attaching queuedSound: ' + qs.sourcename);
			qs.attachSound (qs.sourcename);
			_root.loadQueuedSound ();
		}
	}
}

// soundList [id, sourcename, external, looping, ambient, fadeVolume]

soundList.push (['rhythm','laptop_loop.mp3',true,true,true,20]);
// soundList.push (['cello','wireless_cello_loop.mp3',true,true,true,0]);
// soundList.push (['clarinet','wireless_clarinet_loop.mp3',true,true,true,0]);
// soundList.push (['question', 's_question', false, false, false]);

soundList.push (['ending', 'laptop_ending.mp3', true, false, false, 100]);
soundList.push (['correct', 's_correct', false, false, false, 100]);
soundList.push (['incorrect', 's_incorrect', false, false, false, 100]);
// soundList.push (['appear', 's_appear', false, false, false, 100]);
// soundList.push (['disappear', 's_disappear', false, false, false, 100]);

for (var i=0; i<soundList.length; i++) {
	_root['sound_' + soundList[i][0]] = new Sound (_root);
	var sRef = _root['sound_' + soundList[i][0]];
	sRef.sourcename = soundList[i][1];
	sRef.external = soundList[i][2];
	sRef.looping = soundList[i][3];
	sRef.ambient = soundList[i][4];
	sRef.fadeVolume = soundList[i][5];
	_root.soundLoadQueue.push (sRef);
	soundList[i] = sRef;
}

_root.createEmptyMovieClip ('i_soundFader', newMcDepth ());

_root.i_soundFader.unfadeSounds = function () { // 'in', 'out'
	debug_trace ('unfadeSounds');
	for (var i in _root.soundList) {
		_root.soundList[i].setVolume (100);
	}
}

_root.i_soundFader.fadeSounds = function (dir) { // 'in', 'out'
	debug_trace ('fadeSounds');
	this.direction = dir;
	this.fadeSteps = _root.soundFadeDuration;
	this.stepCount = 0;
	this.fadeList = [];
	for (var i in _root.soundList) {
		if (_root.soundList[i].fadeVolume < 100) {
			debug_trace (_root.soundList[i].sourcename)
			var tVol = (dir == 'in') ? 100 - _root.soundList[i].fadeVolume : _root.soundList[i].fadeVolume - 100;
			var dVol = (dir == 'in') ? 100 : _root.soundList[i].fadeVolume;
			this.fadeList.push ([_root.soundList[i],_root.soundLIst[i].getVolume (), tVol, dVol]);
		}
	}
	this.onEnterFrame = function () { this.fadeStep () };
}

_root.i_soundFader.fadeStep = function () {
	if (this.stepCount <= this.fadeSteps) {
		for (var i in this.fadeList) {
			var newVol = Math.linearTween (this.stepCount, this.fadeList[i][1], this.fadeList[i][2], this.fadeSteps);
			this.fadeList[i][0].setVolume (newVol);
		}
		this.stepCount ++;
	} else {
		for (var i in this.fadeList) {
			this.fadeList[i][0].setVolume (this.fadeList[i][3]);
		}
		this.onEnterFrame = null;
		delete this.fadeList;
		delete this.stepCount;
		delete this.fadeSteps;
	}
}

startSoundtrack = function () {
	for (var i in _root.soundList) {
		if (!_root.soundList[i].playing && _root.soundList[i].ambient) {
			_root.soundList[i].start (0,1000);
			_root.soundList[i].playing = true;
		}
	}
	_root.soundPlaying = true;
}

stopSoundtrack = function () {
	for (var i in _root.soundList) {
		_root.soundList[i].stop ();
		_root.soundList[i].playing = false;
	}
	_root.soundPlaying = false;
}

toggleSound = function () {
	if (_root.soundPlaying) {
		_root.stopSoundtrack ();
	} else {
		_root.startSoundtrack ();
	}
}

/* ---------------- CLASSES ------------------- */

Object.registerClass ('m_smallbtn', Buttonbox);
Object.registerClass ('m_btnClose', Buttonbox);
Object.registerClass ('m_btnReplay', Buttonbox);

/* ---------------- FUNCTIONS ------------------- */

debug_trace = function (a) {
	if (debug) {
		trace (a);
	}
}

newMCDepth = function () {
	return depthCount ++;
}

endWait = function () {
	_level0.i_eventQueue.endWait ();
}

returnRandomArray = function (a) {
	var rand, tempArray = [], rtnArray = [];
	tempArray = tempArray.concat (a);
	while (tempArray.length) {
		rand = Math.floor (Math.random () * tempArray.length);
		rtnArray.push (tempArray[rand]);
		tempArray.splice (rand, 1);
	}
	return rtnArray;
}

startGame = function () {
	Mouse.show ();
	_root.playerMisses = 0;
	_root.currentQuestion = 0;
	_root.setTurnInProgress (false);
	if (_root.firstPlay) {
		_root.loadQueuedSound ();
		_root.showBreaker ();
	} else {
		for (var i in _root.attachedMcs) { 
			_root.attachedMcs[i].stop (); 
			_root.attachedMcs[i].onEnterFrame = null; 
			_root.attachedMcs[i].removeMovieClip ();
		}
		_root.attachedMcs = [];
		_level0.i_eventQueue.addWait (2);
		_level0.i_eventQueue.addEvent (_root, 'initMovie', null, false);
		for (var i in _root.soundList) {
			_root.soundList[i].setVolume (100);
		}
	}
}

initTypewriter = function (instance_name, mw, xy) {
	attachNewMc (_root, 'm_typewriter', instance_name);
	var oRef = _root[instance_name];
	oRef.moveToA (xy);
	oRef.maxWidth = mw;
	oRef.setTextFormat (introTypewTf);
	oRef.typeRate = 30;
	oRef.lineSpace = 36;
	oRef.typeMode = "char";
	oRef.typeAlign = 'left';
	oRef.useCursor = false;
	oRef.onFinished = function () {
		_level0.i_eventQueue.endWait ();
	};
}

showBreaker = function () {
	_root.attachNewMc (_root, 'm_scr_intro', 'i_scr_intro');
	_root.i_scr_intro.onRelease = function () { _root.showBreaker2 (); }
	_root.initTypewriter ('i_typewriter', 530, [48,48]);
	_root.i_typewriter.moveToA ([48,48]);
	_level0.i_eventQueue.addEvent (_root['i_typewriter'], 'write', _root.introT1str, false);
}

showBreaker2 = function () {
	_root.i_scr_intro.onRelease = function () { _root.endBreaker2 (); }
	_level0.i_eventQueue.addEvent (_root['i_typewriter'], 'stopTyping', null, false);
	_level0.i_eventQueue.addEvent (_root['i_typewriter'], 'clear', null, false);
	_level0.i_eventQueue.addEvent (_root['i_typewriter'], 'write', _root.introT2str, false);
}

endBreaker2 = function () {
	_level0.i_eventQueue.addEvent (_root['i_typewriter'], 'stopTyping', null, false);
	_level0.i_eventQueue.addEvent (_root.i_scr_intro, 'tweenTo', [[['_alpha',0]],10], true);
	_level0.i_eventQueue.addEvent (_root.i_scr_intro, 'removeMovieClip', null, false);
	_root.buildXML ('laptop_quizdata','quizdata');
}

endGame = function () {
	getURL ('javascript:window.close ();');
}

showOgolPage = function (l) {
	if (l == 'es') {
		getURL ("http://alertaenlinea.gov/laptop.html", "_blank");
	} else {
		getURL ("http://onguardonline.gov/laptop.html", "_blank");
	}
}

replayGame = function () {
	_root.firstPlay = false;
	startGame ();
}

attachNewMc = function (mc, libname,instname) {
	if (libname != null) {
		mc.attachMovie (libname, instname, newMCDepth () );
	} else {
		mc.createEmptyMovieClip (instname, newMcDepth () );
	}
	_root.attachedMcs.push (_root[instname]);
}

buildXML = function (a,name) {	// create XML object from file
	debug_trace ('buildXML');
	_root[name] = new XML ();
	_root[name].ignoreWhite = true;
//	_root[name].onLoad = _root.xmlloadingDone;
	_root[name].onLoad = function (success) {
		debug_trace ('xmlLoadingDone');
		initMovie ();
	}
	_root[name].load (a + '.xml');
}

xmlLoadingDone = function (b) {
	debug_trace ('xmlLoadingDone');
	initMovie ();
}

answerboxClicked = function (box) {
	debug_trace ('answerboxClicked');
	for (var i in _root.i_qubox.answerMcs) {
		_root.i_qubox.answerMcs[i].kill ();
	}
	_root.i_qubox.i_explanationText.htmlText = box.explanationText;
	_root.i_qubox.i_explanationText.hide ();
	_root.lastAnswer = box.correct;
	if (box.correct) {
		if (_root.soundPlaying) {
			debug_trace ('sound_correct');
			_level0.i_eventQueue.addEvent (_root.sound_correct, 'start', null, false);
		}
	} else {
		if (_root.soundPlaying) {
			debug_trace ('sound_incorrect');
			_level0.i_eventQueue.addEvent (_root.sound_incorrect, 'start', null, false);
		}
		_root.i_qubox.i_explanationText.setTextFormat (_root.explanationIncorrectTf);
	}
	_root.i_qubox.i_explanationText.setTextFormat (_root.explanationTf);
	_level0.i_eventQueue.addWait (10);
	_level0.i_eventQueue.addEvent (_root.i_qubox.i_explanationText, 'show', null, false);
	_level0.i_eventQueue.addWait (10);
	_level0.i_eventQueue.addEvent (_root.i_qubox.i_buttonContinue, 'show', null, false);
}

continueButtonClicked = function () {
	_root.endQuestion ();
	_root.i_soundFader.unfadeSounds ();
}

revealBgScenes = function () {
	for (var i in _root.scenes) {
		i_bgGame['i_'+_root.scenes[i]].show ();
	}
}

showSceneAnimation = function () {
	debug_trace ('showSceneAnimation');
	
	var sceneNum = _root.currentScene._name.substr(-1,1);

	if (_root.i_scenes._visible) {
		_level0.i_eventQueue.addWait (20);
		_level0.i_eventQueue.addEvent (_root.i_scenes,'tweenTo', [_root.i_scenes.tweenTgt,15], true);
		_level0.i_eventQueue.addWait (10);
		_root.i_tabTimeTypewriter.removeMovieClip();
		_root.i_tabLocTypewriter.removeMovieClip();
	}
	
	if (_root.currentScene._name.substr(-1,1) != '1') {
		_level0.i_eventQueue.addEvent (_root, 'playRoute', null, true);
	} else {
		_level0.i_eventQueue.addEvent (_root.currentScene.i_status, 'hide', null, false);
	}
	
	_level0.i_eventQueue.addWait (20);

	_root.i_scenes.tweenTgt = [];
	_root.i_scenes.tweenTgt.push (['_x',_root.currentScene._x]);
	_root.i_scenes.tweenTgt.push (['_y',_root.currentScene._y]);
	_root.i_scenes.tweenTgt.push (['_xscale',_root.currentScene._xscale]);
	_root.i_scenes.tweenTgt.push (['_yscale',_root.currentScene._yscale]);
	_root.i_scenes.tweenTgt.push (['_alpha',0]);
	debug_trace('i_scenes.tweenTgt: ' + _root.i_scenes.tweenTgt);
	
	_level0.i_eventQueue.addEvent (_root.i_scenes,'hide', null, false);
	_level0.i_eventQueue.addEvent (_root.i_scenes.i_bkgd,'gotoAndStop', sceneNum, false)
	_level0.i_eventQueue.addEvent (_root.i_scenes.i_label,'gotoAndStop', sceneNum, false)
	_level0.i_eventQueue.addEvent (_root.i_scenes,'tweenTo', [_root.i_scenes.tweenTgt,1], true);
	_level0.i_eventQueue.addEvent (_root.i_scenes,'show', null, false);
	
	_level0.i_eventQueue.addEvent (_root.i_scenes,'tweenTo', [_root.i_scenes.tweenFsTgt,15], true);
	
	var currTabData = _root.tabData[sceneNum-1];
	debug_trace ('currTabData: ' + currTabData);

	_level0.i_eventQueue.addWait (20);
	
	_root.initTypewriter ('i_tabTimeTypewriter', 250, currTabData[0]);
	_root.i_tabTimeTypewriter.setTextFormat(tabTimeTypewTf);
	_root.i_tabTimeTypewriter.typeAlign = currTabData[1];
	_root.i_tabTimeTypewriter.typeRate = 50;
	_level0.i_eventQueue.addEvent (_root['i_tabTimeTypewriter'], 'write', currTabData[2], true);

	_root.initTypewriter ('i_tabLocTypewriter', 250, [currTabData[0][0], currTabData[0][1]+20]);
	_root.i_tabLocTypewriter.setTextFormat(tabLocTypewTf);
	_root.i_tabLocTypewriter.typeAlign = currTabData[1];
	_root.i_tabLocTypewriter.typeRate = 50;
	_level0.i_eventQueue.addEvent (_root['i_tabLocTypewriter'], 'write', currTabData[3], true);
	
	debug_trace('i_scenes.tweenFsTgt: ' + _root.i_scenes.tweenFsTgt);
	_level0.i_eventQueue.addWait (20);
}

playRoute = function () {
	_root.i_bgGame.i_route.play ();
}

routeDone = function () {
	_level0.i_eventQueue.endWait();
	_root.currentScene.i_status.hide ();
}

showQuestionBg = function () {
	debug_trace ('showQuestionBg');
	_root.i_qubox.i_text.htmlText = '';
	_root.i_qubox._xscale = 10;
	_root.i_qubox._yscale = 10;
	_root.i_qubox._alpha = 0;
	_root.i_qubox.show ();

	var tweenArray = [];
	tweenArray.push (['_x',_root.quboxPos[0]]);
	tweenArray.push (['_y',_root.quboxPos[1]]);
	tweenArray.push (['_xscale',100]);
	tweenArray.push (['_yscale',100]);
	tweenArray.push (['_alpha',100]);

	_level0.i_eventQueue.addEvent (_root.i_qubox, 'tweenTo', [tweenArray, 10], true);
	_level0.i_eventQueue.addEvent (_root.i_soundFader, 'fadeSounds', 'out', false);
}

endQuestion = function () {
	debug_trace ('endQuestion');
	_level0.i_eventQueue.addEvent (_root.i_qubox, 'tweenTo', [[['_alpha',0]], 10], true);
	for (var i in _root.i_qubox.answerMcs) {
		_root.i_qubox.answerMcs[i].removeMovieClip ();
	}
	_root.i_qubox.i_questionText.htmlText = '';
	_root.i_qubox.i_explanationText.htmlText = '';
	_root.i_qubox.i_buttonContinue.hide ();
	_level0.i_eventQueue.addEvent (_root.i_qubox, 'hide', null, false);
//	process correct answer
	if (!_root.lastAnswer) {
		_root.playerMisses ++;
		debug_trace ('playerMisses:  ' + _root.playerMisses);
		_root.currentScene.i_status.gotoAndStop(2);
	} else {
		_root.currentScene.i_status.gotoAndStop(3);
	}
	_level0.i_eventQueue.addEvent (_root.currentScene.i_status, 'show', null, false);
//	proceed
	if (_root.playerMisses == _root.playerMaxMisses || _root.currentQuestion == _root.questionCount) {
		_level0.i_eventQueue.addEvent (_root, 'showEnding', null, false);
	} else {
		_level0.i_eventQueue.addEvent (_root, 'showNextQuestion', null, false);
	}
}

showAnswerBox = function (obj) {
	_level0.i_eventQueue.addEvent (obj, 'tweenTo', [[['_alpha', 100]], 3], true);
}

showQuestion = function (num) {
	debug_trace ('showQuestion: ' + num);
	_root.currentScene = _root.i_bgGame['i_scene'+num];

	showSceneAnimation ();

	var qNode = _root.quizdata.firstChild.childNodes[num-1];
	var questionType = qNode.attributes.questionType;
	var ySpace = (questionType == 'boolean') ? _root.answerBoxYSpacing * 2 : _root.answerBoxYSpacing;
	
	var qText = qNode.firstChild.firstChild.nodeValue;
	
	_root.i_qubox.i_questionText.htmlText = qText;
	_root.i_qubox.i_questionText.setTextFormat (_root.questionTf);
	_root.i_qubox.i_questionText._height = _root.i_qubox.i_questionText.textHeight + 6;
	var yCursor = _root.i_qubox.i_questionText._y + _root.i_qubox.i_questionText._height + ySpace;
	
	_level0.i_eventQueue.addEvent (_root.sound_question, 'start', null, false);
	_level0.i_eventQueue.addWait (10);
	showQuestionBg();

	for (var i = 0; i < qNode.childNodes[1].childNodes.length; i ++) {
		var ansText = qNode.childNodes[1].childNodes[i].firstChild.firstChild.nodeValue;
		var explText = qNode.childNodes[1].childNodes[i].childNodes[1].firstChild.nodeValue;
		var ansCorrect = qNode.childNodes[1].childNodes[i].attributes.correct;

		attachNewMc (_root.i_qubox, 'm_ansbox', 'i_ansbox'+i);
		var o = _root.i_qubox['i_ansbox'+i];
		_root.i_qubox.answerMcs.push (o);
		o.propOnRelease = _root.answerBoxClicked;
		o.bgColors = _root.ansboxBgColors;
		o.olColors = _root.ansboxOlColors;
		if (questionType == 'boolean') {
			o.textFormat = _root.ansboxBoolTf;
		} else {
			o.textFormat = _root.ansboxTf;
		}
		o.textColors = _root.ansboxTextColors;
		o.textPadding = _root.answerTextPadding;
		o.correct = (ansCorrect == "true") ? true : false;
		o.answerText = ansText;
		o.explanationText = explText;
		o._x = _root.answerBoxIndent;
		o._y = yCursor;
		yCursor += o._height + ySpace;
		o._alpha = 0;
		
//		_level0.i_eventQueue.addEvent (o, 'tweenTo', [[['_alpha', 100]], 3], true);
		showAnswerBox (o);
	}

	_root.i_qubox.i_explanationText._y = yCursor;
	yCursor += _root.i_qubox.i_explanationText._height + ySpace;
}

beginTurn = function () {
	debug_trace ('--------\nbeginTurn');
	_root.setTurnInProgress (true);
	
	if (_root.soundPlaying) {

	}
	_root.showNextQuestion ();

}

showNextQuestion = function () {
	_root.currentQuestion ++;
	_root.showQuestion (_root.currentQuestion);
}

showEnding = function () {
	debug_trace ('showEnding');
	_root.attachNewMc (_root, 'm_scr_ending', 'i_scr_ending');
	_root.i_scr_ending._alpha = 0;
	_root.i_scr_ending.hide ();
	if (_root.playerMisses == 0) {
		_root.i_scr_ending.gotoAndStop(3);
	} else if (_root.playerMisses < _root.playerMaxMisses) {
		_root.i_scr_ending.gotoAndStop(2);
	} else {
		_root.i_scr_ending.gotoAndStop(1);
	}
	
	_root.attachNewMc (_root.i_scr_ending, 'm_btnReplay', 'i_btnReplay');
	_root.i_scr_ending.i_btnReplay.moveToA ([425,445]);
	_root.i_scr_ending.i_btnReplay.bgColors = _root.barbtnBgColors;
	_root.i_scr_ending.i_btnReplay.olColors = _root.barbtnOlColors;
	_root.i_scr_ending.i_btnReplay.textColors = _root.barbtnTextColors;
	_root.i_scr_ending.i_btnReplay.onRelease = function () { _root.replayGame (); }

	_root.attachNewMc (_root.i_scr_ending, 'm_btnClose', 'i_btnClose');
	_root.i_scr_ending.i_btnClose.moveToA ([507,445]);
	_root.i_scr_ending.i_btnClose.bgColors = _root.barbtnBgColors;
	_root.i_scr_ending.i_btnClose.olColors = _root.barbtnOlColors;
	_root.i_scr_ending.i_btnClose.textColors = _root.barbtnTextColors;
	_root.i_scr_ending.i_btnClose.onRelease = function () { _root.endGame (); }

	_level0.i_eventQueue.addEvent (_root.i_scr_ending, 'show', null, false);
	_level0.i_eventQueue.addEvent (_root.i_scr_ending, 'tweenTo', [[['_alpha',100]],10], true);
	if (_root.soundPlaying) {
		_level0.i_eventQueue.addEvent (_root, 'stopSoundtrack', null, false);
		_level0.i_eventQueue.addWait (10);
		_level0.i_eventQueue.addEvent (_root.sound_ending, 'start', null, false);
		_root.restartSoundOnReplay = true;
	}
}

/* ---------------- MOVIE INITIALIZATION ------------------- */

initMovie = function () {
	debug_trace ('initMovie');

	_root.i_breaker.removeMovieClip ();
	
	_root.questionCount = _root.quizdata.firstChild.childNodes.length;

	_root.questionOrder = [];

	for (var i=0; i<_root.questionCount; i++) {
		_root.questionOrder.push (i);
	}

	if (_root.restartSoundOnReplay) {
		_root.startSoundtrack ();
	}

	// draw game board
	
	_root.attachNewMc (_root, 'm_bgGame', 'i_bgGame');
	for (var i=0; i<_root.scenes.length; i++) {
		i_bgGame['i_'+_root.scenes[i]].i_label.hide();
		i_bgGame['i_'+_root.scenes[i]].i_bkgd.gotoAndStop(i+1);
		i_bgGame['i_'+_root.scenes[i]].hide();
	}
	
	_root.attachNewMc (_root, 'm_scenes', 'i_scenes');
	_root.i_scenes.hide ();
	_root.i_scenes.i_status.hide ();
	_root.i_scenes.tweenFsTgt = [];
	_root.i_scenes.tweenFsTgt.push (['_x',0]);
	_root.i_scenes.tweenFsTgt.push (['_y',0]);
	_root.i_scenes.tweenFsTgt.push (['_xscale',100]);
	_root.i_scenes.tweenFsTgt.push (['_yscale',100]);
	_root.i_scenes.tweenFsTgt.push (['_alpha',100]);


	_root.attachNewMc (_root, 'm_b_sound', 'i_buttonSound');
	_root.i_buttonSound.moveToA ([605,450]);
	_root.i_buttonSound.gotoAndStop (_root.soundPlaying ? 1 : 3);
	_root.i_buttonSound.onRelease = function () {
		if (!_global.jdgButtonHold && !this.buttonHold) {
			_root.toggleSound ();
			this.gotoAndStop (_root.soundPlaying ? 1 : 3);
		}
	}
	_root.i_buttonSound.onRollOver = function () {
		if (!_global.jdgButtonHold && !this.buttonHold) {
			this.gotoAndStop (_root.soundPlaying ? 2 : 4);
		}
	}
	_root.i_buttonSound.onRollOut = function () {
		if (!_global.jdgButtonHold && !this.buttonHold) {
			this.gotoAndStop (_root.soundPlaying ? 1 : 3);
		}
	}

	// set up question box
	
	_root.attachNewMc (_root, 'm_qubox', 'i_qubox');
	_root.i_qubox.hide();
	_root.i_qubox.answerMcs = [];
	
	_root.attachNewMc (_root.i_qubox, 'm_smallbtn', 'i_buttonContinue');
	_root.i_qubox.i_buttonContinue.moveToA (_root.continueButtonPos);
//	_root.i_qubox.i_buttonContinue.__proto__ = Buttonbox.prototype;
	_root.i_qubox.i_buttonContinue.bgColors = _root.contbtnBgColors;
	_root.i_qubox.i_buttonContinue.olColors = _root.contbtnOlColors;
	_root.i_qubox.i_buttonContinue.textColors = _root.contbtnTextColors;
	_root.i_qubox.i_buttonContinue.hide ();
	_root.i_qubox.i_buttonContinue.onRelease = function () { _root.continueButtonClicked (); }

	_root.i_qubox.createTextField ('i_questionText', 1, _root.questionTextPadding, _root.questionTextPadding * .6, _root.i_qubox._width - (_root.questionTextPadding * 2), _root.i_qubox._height * 4);
	var o = _root.i_qubox.i_questionText;
	o.multiline = true;
	o.wordWrap = true;
	o.embedFonts = true;
	o.selectable = false;
	o.html = true;
	o.setNewTextFormat (_root.questionTf);
	
	_root.i_qubox.createTextField ('i_explanationText', 2, _root.questionTextPadding, 480, _root.i_qubox._width - (_root.questionTextPadding * 2), _root.i_qubox._height * 4);
	var p = _root.i_qubox.i_explanationText;
	p.multiline = true;
	p.wordWrap = true;
	p.embedFonts = true;
	p.selectable = false;
	p.html = true;
	p.setNewTextFormat (_root.explanationTf);
	p.hide();

	_level0.i_eventQueue.addWait(_root.i_bgGame._totalframes);
	_level0.i_eventQueue.addEvent(_root, 'revealBgScenes', null, false);
	_level0.i_eventQueue.addWait(31);
	
	showNextQuestion();
	
}


/* ---------------- RUNTIME ------------------- */

if (_root == _level0) { 
	startGame ();
}
