/* 
--------------------------------------------------------------
typewriter.as

Use to create typewriter text effect in Flash MX.
Requires two movie clips in Library with the
following id names (set through Linkage in Library):

'm_typewriter' - empty movie clip
'm_typeCursor' - desired cursor shape

Standard MovieClip properties and methods are
available in Typewriter (_x, _y, _rotation, etc.)

-----
Usage
-----

myMovieClip.attachMovie ('m_typewriter', 'myTypewriter', depth);

	Creates a new Typewriter object

----------
Properties
----------

Typewriter.maxWidth 

	Maximum text line length in pixels

Typewriter.lineSpace

	Leading in pixels

Typewriter.typeAlign

	Text alignment (left|center|right)

Typewriter.vertAlign

	Text alignment (top|bottom)

Typewriter.writeMode

	(char|line)

Typewriter.typeRate

	Delay in msec between each new char or line is displayed

Typewriter.useCursor

	boolean

Typewriter.cursorBlinkRate

	msec (fixed 50% duty cycle)


-------
Methods
-------

Typewriter.setTextFormat (myTextFormat);

	Specifies text format using a standard AS TextFormat object.

Typewriter.write (myString);

	Writes a string to the typewriter.

Typewriter.clear ();

	Erases typewriter display

Typewriter.stopTyping ();

	Ends typing immediately

Typewriter.onFinished

	Handler invoked when typewriter finishes typing

Typewriter.toggleCursor (b)

	Set visibility of cursor to boolean b

--------------------------------------------------------------
*/



// new getTextExtent to correct inaccurate results on Mac
// 'fudge' factor of 17.473 may be font-dependent

// I ended up not using the getTextExtent action and 
// recommend avoiding it altogether.

TextFormat.prototype.getTextExtentFix = function (text) {
	var ext = this.getTextExtent (text);
	if (getVersion ().substr (0,3) == 'MAC') {
		ext.height = Math.ceil (ext.height / 20);
		ext.width = Math.ceil (ext.width / 20);
	}
	ASSetPropFlags (TextFormat, ['getTextExtentFix'],1);
	return ext;
}

// adds method to String object; word-wraps input string
// to fit specified width using a defined TextFormat object.
// Returns array containing individual lines of text.

String.prototype.toLines = function (maxLen, textFmt) {
	var forceLeftFmt = new TextFormat ();
	forceLeftFmt.align = 'left';
	_level0.createTextField ('dummyFld', 3500, 0, 0, 500, 100);
	_level0.dummyFld.setNewTextFormat (textFmt);
	_level0.dummyFld.setNewTextFormat (forceLeftFmt);
	_level0.dummyFld._visible = false;
	_level0.dummyFld.text = ' ';
	var spcWid = _level0.dummyFld.textWidth;
	spcWid *= 1.3;                       //fix embed font madness
	var inputWords = this.split (' '), outputLines = [], w = 0, l = 0;
	while (inputWords.length) {
		var wd = inputWords.shift ();
		_level0.dummyFld.text = wd; var wdWid = _level0.dummyFld.textWidth;
		wdWid *= 1.3                    // fix embed font madness
		if ((w + wdWid + spcWid) < maxLen * 0.9) {
			outputLines[l] += (outputLines[l].length) ? ' ' + wd : wd;
			w += wdWid + spcWid;
		} else {
			l ++; outputLines[l] += wd;
			w = wdWid;
		}
	}
	_level0.dummyFld.removeTextField ();
	delete forceLeftFmt;
	return outputLines;
	ASSetPropFlags (String.prototype,['toLines'],1);
}



Cursor = function () {}
Cursor.prototype = new MovieClip ();

Cursor.prototype.initCursor = function (x, y, w, h) {
	this._x = x;
	this._y = y;
	this._width = w;
	this._height = h;
}

Cursor.prototype.hideCursor = function () {
	clearInterval (this.blinking);
	this._visible = false;
}

Cursor.prototype.blink = function (b) {
	if (b) {
		clearInterval (this.blinking);
		this._visible = !this._visible;
		this.blinking = setInterval (this, 'blink' , this._parent.cursorBlinkRate, true);
	} else {
		clearInterval (this.blinking);
	}
}

Object.registerClass ('m_typeCursor', Cursor);




Typewriter = function () {
	this.typeRate = 50;  // ms
	this.lineSpace = 12;  // pixels
	this.typeAlign = 'left';  // alignment
	this.vertAlign = 'top'
	this.maxWidth = 200;
	this.useCursor = true;
	this.cursorBlinkRate = 400;
	this.typeMode = 'char';
	this.lineCounter = 0;
}

Typewriter.prototype = new MovieClip ();

Typewriter.prototype.setTextFormat = function (tfObj) {
	this.textFormat = tfObj;
//	this.onFinished ();
}

Typewriter.prototype.getHeight = function () {
//	trace ('height: ' + (this.lineCounter * this.lineSpace))
	return (this.lineCounter * this.lineSpace);
}

Typewriter.prototype.clear = function () {
	while (this.lineCounter > -1) {
		this['typeLine' + this.lineCounter].removeTextField ();
		this.lineCounter --;
	}
	this.lineCounter = 0;
	this.typeCursor._x = 0; this.typeCursor._y = 0;
	this.typeCursor.hideCursor ();
	this.onFinished ();
}

Typewriter.prototype.write = function (text) {
	if (this.useCursor && ! this.typeCursor) {
		this.attachMovie ('m_typeCursor', 'typeCursor', this.getDepth() + 1);
	}
	this.typeCursor._height = this.textFormat.size;
	this.typeCursor._width = Math.floor (this.textFormat.size * 2/3);
	this.typeCursor._visible = true;
	this.linesBuffer = text.toLines (this.maxWidth, this.textFormat);
	this.writeLine ();
}

Typewriter.prototype.writeLine = function () {
	if (this.linesBuffer.length) {
		var l = this.lineCounter;
		var ltemp = this.lineCounter;
		var y = (this.vertAlign == 'bottom') ? this.lineSpace : l * this.lineSpace;
		var text = this.linesBuffer.shift ();
		var s = this.textFormat.getTextExtentFix (text);
		this.createTextField ('typeLine' + l, this.getDepth() + l + 2, 0, y, this.maxWidth, s.height * 1.4);
		var fld = this['typeLine' + l];
		with (fld) {
			setNewTextFormat (this.textFormat);
			embedFonts = true;
			multiline = false;
			wordWrap = false;
			selectable = false;
			if (this.textBg) {
				background = true;
				backgroundColor = this.textBg;
			}
		}
		this.typeCursor.blink (false);
		if (this.vertAlign == 'bottom') {
			while (ltemp > -1) {
				this['typeLine' + ltemp]._y -= this.lineSpace;
				ltemp --;
			}
		}
		if (this.typeMode == 'char') {
			this.writeBuffer = text.split ('');
			this.typing = setInterval (this, 'writeLineChars', this.typeRate, this['typeLine' + l]);
		} else {
			this.typing = setInterval (this, 'writeLineWhole', this.typeRate, this['typeLine' + l], text);
		}
		debug_trace ("wrote line " + l);
		this.lineCounter ++;
//		debug_trace (this.lineCounter);
	} else {
		this.typeCursor._x += Math.floor (this.textFormat.size * 2/3);
		this.typeCursor.blink (true);
		clearInterval (this.typing);
		this.onFinished ();
	}
}

Typewriter.prototype.writeLineWhole = function (fld, text) {
		fld.text += text;
		var w = fld.textWidth;
		switch (this.typeAlign) {
			case 'center':
				fld._x = Math.floor (w / 2) * -1;
				break;
			case 'right':
				fld._x = Math.floor (w * -1);
		}
		this.typeCursor._x = (fld._x + w);
		this.typeCursor._y = (fld._y + fld.textHeight - this.typeCursor._height) + 1;
		updateAfterEvent();
		clearInterval (this.typing);
		this.writeLine ();
}

Typewriter.prototype.writeLineChars = function (fld) {
	if (this.writeBuffer.length) {
		fld.text += this.writeBuffer.shift ();
		var w = fld.textWidth;
		switch (this.typeAlign) {
			case 'center':
				fld._x = Math.floor (w / 2) * -1;
				break;
			case 'right':
				fld._x = Math.floor (w * -1);
		}
		this.typeCursor._x = (fld._x + w);
		this.typeCursor._y = (fld._y + fld.textHeight - this.typeCursor._height) + 1;
		updateAfterEvent();
	} else {
		clearInterval (this.typing);
		this.writeLine ();
	}
}

Typewriter.prototype.stopTyping = function () {
	clearInterval (this.typing);
}

Typewriter.prototype.toggleCursor = function (b) {
	if (b) {
		this.typeCursor.blink (true);
	} else {
		this.typeCursor.hideCursor ();
	}
}

Object.registerClass ('m_typewriter', Typewriter);
