/*
event_queue.as
event queue manager

USAGE:

Places an event in the queue for later execution:

_level0.i_eventQueue.addEvent (o,f,a,w);

   o = OBJECT which will receive event
   f = FUNCTION or method of object to call
   a = ARGUMENTS passed to function or method
   w = WAIT before executing next event (boolean)

Clears the queue's pending wait state:

_level0.i_eventQueue.endWait ();



*/

_level0.createEmptyMovieClip ("i_eventQueue", 10000);
_level0.i_eventQueue.eQueue = [];
_level0.i_eventQueue.wait = false;
_level0.i_eventQueue.onEnterFrame = function () {}

_level0.i_eventQueue.addEvent = function (o, f, a, w) {
//	trace ("queue event added - " + f + " (" + a + "), " + w);
	this.eQueue = this.eQueue.concat ([o, f, a, w]);
	this.onEnterFrame = function () { this.processQueue (); }
}

_level0.i_eventQueue.addWait = function (num) {
	num = (num == null) ? 1 : num;
	while (num) {
		this.eQueue = this.eQueue.concat ([_level0, null, null, false]);
		num --;
	}
}

_level0.i_eventQueue.endWait = function () {
	this.wait = false;
//	trace ("queue event ended - wait = " + this.wait);
}

_level0.i_eventQueue.processQueue = function () {
//	trace ("queue running with " + this.eQueue.length + " items, " + this.wait);
	if (this.eQueue.length > 0) {
		if (!this.wait) {
			var obj = this.eQueue.shift (), act = this.eQueue.shift ();
			var arg = this.eQueue.shift (), w = this.eQueue.shift ();
//			trace ("queue now running event: " + act + " (" + arg + "), " + w);
			this.wait = w;
			obj[act](arg);
		}
	} else {
//		trace ("killing queue process");
		this.onEnterFrame = null;
	}
}

