MovieClip.prototype.moveToA = function (v) { // v = [x,y]
	this._x = v[0];
	this._y = v[1];
	ASSetPropFlags (MovieClip.prototype, ['moveToA'], 1);
}

MovieClip.prototype.moveBy = function (v) { // v = [x,y]
	this._x += v[0];
	this._y += v[1];
	ASSetPropFlags (MovieClip.prototype, ['moveBy'], 1);
}

MovieClip.prototype.glideBy = function (vs) { // vs = [x,y,steps]
	this.glideStart = [this._x, this._y];
	this.glideVector = vs;
	this.glideStepCount = 0;
	this.onEnterFrame = function () { this.glideStep (); }	
	ASSetPropFlags (MovieClip.prototype, ['glideBy'], 1);
}

MovieClip.prototype.glideTo = function (vs) { // vs = [x,y,steps]
	this.glideBy ([vs[0] - this._x, vs[1] - this._y, vs[2]]);
	ASSetPropFlags (MovieClip.prototype, ['glideTo'], 1);
}

MovieClip.prototype.glideStep = function () {
	if (this.glideStepCount <= this.glideVector[2]) {
		this._x = Math.easeOutCubic (this.glideStepCount, this.glideStart[0], this.glideVector[0], this.glideVector[2]);
		this._y = Math.easeOutCubic (this.glideStepCount, this.glideStart[1], this.glideVector[1], this.glideVector[2]);
		this.glideStepCount ++;
	} else {
		_level0.i_eventQueue.endWait ();
		this.onEnterFrame = null;
	}
	ASSetPropFlags (MovieClip.prototype, ['glideStep'], 1);
}

MovieClip.prototype.addTint = function (r, g, b, a) {
	var clr = new Color (this);
	clr.setTint (r, g, b, a);
	delete (clr);
	ASSetPropFlags (MovieClip.prototype, ['addTint'], 1);
}

MovieClip.prototype.removeTint = function () {
	var clr = new Color (this);
	clr.reset ();
	delete (clr);
	ASSetPropFlags (MovieClip.prototype, ['removeTint'], 1);
}

MovieClip.prototype.fadeOut = function (f) { // frames
	this.fadeStart = 100;
	this.fadeAmt = -100;
	this.fadeSteps = f;
	this.fadeStepCount = 0;
	this.onEnterFrame = function () { this.fadeStep (); }
	ASSetPropFlags (MovieClip.prototype, ['fadeOut'], 1);
}

MovieClip.prototype.fadeIn = function (f) { // frames
	this._alpha = 0;
	this._visible = true;
	this.fadeStart = 0;
	this.fadeAmt = 100;
	this.fadeSteps = f;
	this.fadeStepCount = 0;
	this.onEnterFrame = function () { this.fadeStep (); }
	ASSetPropFlags (MovieClip.prototype, ['fadeIn'], 1);
}

MovieClip.prototype.fadeStep = function () {
	if (this.fadeStepCount <= this.fadeSteps) {
		this._alpha = Math.linearTween (this.fadeStepCount, this.fadeStart, this.fadeAmt, this.fadeSteps);
		this.fadeStepCount ++;
	} else {
		if (this.fadeAmt == -100) {
			this._visible = false;
		} else {
			this._alpha = 100;
		}
		_level0.i_eventQueue.endWait ();
		this.onEnterFrame = null;
	}
	ASSetPropFlags (MovieClip.prototype, ['fadeStep'], 1);
}