// shopping.as
// version 0.01
// 9/8/2005 JM

/* ---------------- INCLUDE LIBRARIES ------------------- */

#include "color_extensions.as"
#include "easing.as"
#include "event_queue.as"
#include "movieClip_extensions.as"

/* ---------------- DECLARATION ------------------- */

// _root variables

var adSeen;
_global.jdgBtnHold = false;
var briefPanelHomes = [[20,98], [229,98], [438,98]];
var detailPanelLoc = [219,98];
var curAd;
var depthCount = 50;
var attachedMcs = [];
var btnBlinkRate = 500; //ms
var soundPlaying = true;
var swfRoot = _root;
var restartSoundOnReplay = false;
var firstPlay = true;

/* ---------------- SOUNDS ------------------- */

/*
lineup_piano_mono.mp3
lineup_trumpet_mono.mp3
lineup_rhythm_mono.mp3
*/

var queuedSound;
var soundLoadQueue = [];
var soundList = [];
loadQueuedSound = function () {
	if (_root.queuedSound.ambient) {
		_root.queuedSound.start (0,1000);
		_root.queuedSound.playing = true;
	}
	if (_root.soundLoadQueue.length > 0) {
		var qs = _root.soundLoadQueue.pop ();
		_root.queuedSound = qs;
		if (qs.external) {
			qs.onLoad = _root.loadQueuedSound;
			qs.loadSound (qs.sourcename);
		} else {
			qs.attachSound (qs.sourcename);
			_root.loadQueuedSound ();
		}
	}
}

// soundList [id, sourcename, external, looping, ambient]

soundList.push (['rhythm','snd_lineup_rhythm',false,false,true]);
soundList.push (['piano','lineup_piano_mono.mp3',true,true,true]);
soundList.push (['trumpet','lineup_trumpet_mono.mp3',true,true,true]);
soundList.push (['ending','lineup_ending.mp3',true,false,false]);

for (var i in soundList) {
	_root['sound_' + soundList[i][0]] = new Sound (_root);
	var sRef = _root['sound_' + soundList[i][0]];
	sRef.sourcename = soundList[i][1];
	sRef.external = soundList[i][2];
	sRef.looping = soundList[i][3];
	sRef.ambient = soundList[i][4];
	_root.soundLoadQueue.push (sRef);
	soundList[i] = sRef;
}

/* ---------------- CLASSES ------------------- */


/* ---------------- FUNCTIONS ------------------- */

newMCDepth = function () {
	return depthCount ++;
}

endWait = function () {
	_level0.i_eventQueue.endWait ();
}

startGame = function () {
	if (_root.firstPlay) {
		loadQueuedSound ();
	}
	_root.adSeen = [false, false, false];
	for (var i in _root.attachedMcs) { _root.attachedMcs[i].removeMovieClip (); }
	_root.attachNewMc ('m_scr_intro', 'i_breaker');
	_root.i_intro._visible = false;
	_root.i_breaker.onRelease = function () { _root.endBreaker (); }
}

endBreaker = function () {
	_root.initMovie ();
}

endGame = function () {
	getURL ('javascript:window.close ();');
}

btnInit = function (o,f,a) {
	o.handler = f;
	o.args = a;

	o.gotoAndStop (1);

	o.onRollOver = function () {
		if (!_global.jdgBtnHold && !this.btnHold) {
			o.gotoAndStop (2);
		}
	}
	
	o.onRollOut = function () {
		if (!_global.jdgBtnHold && !this.btnHold) {
			o.gotoAndStop (1);
		}
	}
	
	o.onRelease = function () {
		if (!_global.jdgBtnHold && !this.btnHold) {
			_root[this.handler](this.args);
		}
	}
}

viewAd = function (ad) {

	_root.curAd = ad;

	for (var i = 1; i < 4; i++) {
		if (i != ad) {
			_level0.i_eventQueue.addEvent (_root['i_panel_brief_0' + i], 'fadeOut', 10, false);
		}
	}
	_root.i_detail.gotoAndStop (ad);
	_level0.i_eventQueue.addEvent (_root.i_headline, 'fadeOut', 10, true);
	_level0.i_eventQueue.addEvent (_root.i_headline, 'gotoAndStop', ad + 1, false);
	if (ad != 1) {
		_level0.i_eventQueue.addEvent (_root['i_panel_brief_0' + ad], 'glideTo', [_root.briefPanelHomes[0][0], _root.briefPanelHomes[0][1], 16], false);
	}
	_level0.i_eventQueue.addEvent (_root.i_headline, 'fadeIn', 10, false);
	_level0.i_eventQueue.addWait (16);
	_level0.i_eventQueue.addEvent (_root.i_detail, 'fadeIn', 10, true);
	_root['i_panel_brief_0'+ad].i_btn_readmore._visible = false;
	_root.adSeen[ad-1] = true;


	_root.showAdButtons (true);
}

returnToAds = function () {
	_root.i_popup_prompt._visible = false;
	_level0.i_eventQueue.addEvent (_root.i_headline, 'fadeOut', 10, false);
	_level0.i_eventQueue.addEvent (_root.i_detail, 'fadeOut', 10, true);
	_level0.i_eventQueue.addEvent (_root.i_headline, 'gotoAndStop', 1, false);
	_level0.i_eventQueue.addEvent (_root['i_panel_brief_0' + _root.curAd], 'glideTo', [_root.briefPanelHomes[_root.curAd-1][0], _root.briefPanelHomes[_root.curAd-1][1], 16], false);
	_root['i_panel_brief_0'+_root.curAd].i_btn_readmore._visible = true;
	_level0.i_eventQueue.addWait (16);
	for (var i = 1; i < 4; i++) {
		if (i != _root.curAd) {
			_level0.i_eventQueue.addEvent (_root['i_panel_brief_0' + i], 'fadeIn', 10, false);
		}
	}
	_level0.i_eventQueue.addEvent (_root.i_headline, 'fadeIn', 10, true);
	_root.showAdButtons (false);
}

showPopupPanel = function () {
	_root.i_popup_prompt.fadeIn (10);
	_root.showAdButtons (false);
}

showOgolPage = function (l) {
	if (l == 'es') {
		getURL ("http://alertaenlinea.gov/shopping_es.html", "_blank");
	} else {
		getURL ("http://onguardonline.gov/shopping.html", "_blank");
	}
}

buyProduct = function (b) { // boolean
	if (b || _root.adSeen.toString ().lastIndexOf ('false') == -1) {
		_root.i_popup_prompt._visible = false;	
		_level0.i_eventQueue.addEvent (_root.i_detail, 'fadeOut', 10, true);
//		_level0.i_eventQueue.addEvent (_root.i_detail, 'gotoAndStop', _root.curAd + 3, false);
		_level0.i_eventQueue.addEvent (_root, 'reviewAnswerDetail', null, false);
//		_root.i_detail.i_b_clickhere.onRelease = function () { _root.showOgolPage (); }
		_level0.i_eventQueue.addEvent (_root.i_detail, 'fadeIn', 10, true);
		_level0.i_eventQueue.addEvent (_root['i_panel_brief_0' + _root.curAd], 'gotoAndStop', 2, false);
		if (_root.soundPlaying) {
			_level0.i_eventQueue.addEvent (_root, 'stopSoundtrack', null, false);
			_level0.i_eventQueue.addEvent (_root.sound_ending, 'start', null, false);
			_root.restartSoundOnReplay = true;
		}
		_root.showAdButtons (false);
		_root.showEndButtons (true);
	} else {
		_root.showPopupPanel ();
	}

}

replayGame = function () {
	_root.firstPlay = false;
	startGame ();
}

showAdButtons = function (b) { //bool
	_root.i_btnReturn._visible = b;
	_root.i_btnBuy._visible = b;
}

showEndButtons = function (b) { //bool
	_root.i_btnClose._visible = b;
	_root.i_btnReplay._visible = b;
}

attachNewMc = function (libname,instname) {
	_root.attachMovie (libname, instname, newMCDepth() );
	_root.attachedMcs.push (_root[instname]);
}

startSoundtrack = function () {
	for (var i in _root.soundList) {
		if (!_root.soundList[i].playing && _root.soundList[i].ambient) {
			_root.soundList[i].start (0,1000);
			_root.soundList[i].playing = true;
		}
	}
	_root.soundPlaying = true;
}

stopSoundtrack = function () {
	for (var i in _root.soundList) {
		_root.soundList[i].stop ();
		_root.soundList[i].playing = false;
	}
	_root.soundPlaying = false;
}

toggleSound = function () {
	if (_root.soundPlaying) {
		_root.stopSoundtrack ();
	} else {
		_root.startSoundtrack ();
	}
}

reviewAdDetail = function () {
	_root.i_detail.gotoAndStop (_root.i_detail._currentframe - 3);
	_root.i_detail.i_b_viewAd._visible = false;
	_root.i_detail.i_b_viewAnswer._visible = true;
}

reviewAnswerDetail = function () {
	_root.i_detail.gotoAndStop (_root.i_detail._currentframe + 3);
	_root.i_detail.i_b_viewAd._visible = true;
	_root.i_detail.i_b_viewAnswer._visible = false;
}

/* ---------------- MOVIE INITIALIZATION ------------------- */

initMovie = function () {
	_root.i_breaker.removeMovieClip ();
	
	if (_root.restartSoundOnReplay) {
		_root.startSoundtrack ();
	}

	_root.attachNewMc ('m_gamescreen', 'i_gamescreen');

	for (var i = 3; i > 0; i--) {
		_root.attachNewMc ('m_panel_brief_0' + i, 'i_panel_brief_0' + i);
		var oRef = _root['i_panel_brief_0' + i];
		oRef.gotoAndStop (1);
		oRef.attachMovie ('m_b_readmore', 'i_btn_readmore', 10);
		oRef.i_btn_readmore.moveToA ([111,279]);
		_root.btnInit (oRef.i_btn_readmore, 'viewAd', i);
		oRef.moveToA ([-200,98]);
		_level0.i_eventQueue.addEvent (oRef, 'glideTo', [_root.briefPanelHomes[i-1][0], _root.briefPanelHomes[i-1][1], 16], false);
	}
	
	_root.attachNewMc ('m_headlines', 'i_headline');
	_root.i_headline.gotoAndStop (1);
	_root.i_headline.moveToA ([0,0]);
	
	_root.attachNewMc ('m_b_returnToAds', 'i_btnReturn');
	_root.i_btnReturn.moveToA ([475,445]);
	_root.btnInit (_root.i_btnReturn, 'returnToAds');
	_root.i_btnReturn._visible = false;

	_root.attachNewMc ('m_b_buyProduct', 'i_btnBuy');
	_root.i_btnBuy.moveToA ([358,445]);
	_root.btnInit (_root.i_btnBuy, 'buyProduct', false);
	_root.i_btnBuy._visible = false;
	
	_root.attachNewMc ('m_b_close', 'i_btnClose');
	_root.i_btnClose.moveToA ([475,445]);
	_root.btnInit (_root.i_btnClose, 'endGame');
	_root.i_btnClose._visible = false;
	
	_root.attachNewMc ('m_b_replay', 'i_btnReplay');
	_root.i_btnReplay.moveToA ([393,445]);
	_root.btnInit (_root.i_btnReplay, 'replayGame');
	_root.i_btnReplay._visible = false;
	
	_root.attachNewMc ('m_panelDetail', 'i_detail');
	_root.i_detail.gotoAndStop (1);
	_root.i_detail.moveToA (_root.detailPanelLoc);
	_root.i_detail.i_b_viewAd._visible = false;
	_root.i_detail.i_b_viewAnswer._visible = false;
	_root.btnInit (_root.i_detail.i_b_viewAd, 'reviewAdDetail');
	_root.btnInit (_root.i_detail.i_b_viewAnswer, 'reviewAnswerDetail');
	_root.i_detail._visible = false;
	
	_root.attachNewMc ('m_popup_prompt', 'i_popup_prompt');
	_root.i_popup_prompt.moveToA ([121,95]);
	_root.i_popup_prompt._visible = false;
	_root.btnInit (_root.i_popup_prompt.i_m_b_returnToAds2, 'returnToAds');
	_root.btnInit (_root.i_popup_prompt.i_m_b_buyProduct2, 'buyProduct', true);
	
	_root.attachNewMc ('m_b_sound', 'i_btnSound');
	_root.i_btnSound.moveToA ([600,445]);
	_root.i_btnSound.gotoAndStop (_root.soundPlaying ? 1 : 3);
	_root.i_btnSound.onRelease = function () {
		if (!_global.jdgBtnHold && !this.btnHold) {
			_root.toggleSound ();
			this.gotoAndStop (_root.soundPlaying ? 1 : 3);
		}
	}
	_root.i_btnSound.onRollOver = function () {
		if (!_global.jdgBtnHold && !this.btnHold) {
			this.gotoAndStop (_root.soundPlaying ? 2 : 4);
		}
	}
	_root.i_btnSound.onRollOut = function () {
		if (!_global.jdgBtnHold && !this.btnHold) {
			this.gotoAndStop (_root.soundPlaying ? 1 : 3);
		}
	}
}


/* ---------------- RUNTIME ------------------- */

// initMovie ();
if (_root == _level0) { startGame (); }